/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.BalmConfigProperty;
import net.blay09.mods.balm.api.config.BalmConfigPropertyImpl;
import net.blay09.mods.balm.api.config.Config;
import net.blay09.mods.balm.api.event.ConfigReloadedEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.blay09.mods.balm.api.network.SyncConfigMessage;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBalmConfig
implements BalmConfig {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBalmConfig.class);
    private final Map<Class<?>, BalmConfigData> activeConfigs = new HashMap();
    private final Map<Class<?>, BalmConfigData> defaultConfigs = new HashMap();
    private final Map<Class<?>, Function<?, ?>> syncMessageFactories = new HashMap();

    public void initialize() {
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> {
            for (BalmConfigData config : this.activeConfigs.values()) {
                SyncConfigMessage<?> message = this.getConfigSyncMessage(config.getClass());
                if (message == null) continue;
                Balm.getNetworking().sendTo((class_1657)event.getPlayer(), message);
            }
        });
        Balm.getEvents().onEvent(ConfigReloadedEvent.class, event -> {
            MinecraftServer server = Balm.getHooks().getServer();
            if (server != null) {
                for (BalmConfigData config : this.activeConfigs.values()) {
                    SyncConfigMessage<?> message = this.getConfigSyncMessage(config.getClass());
                    if (message == null) continue;
                    Balm.getNetworking().sendToAll(server, message);
                }
            }
        });
    }

    @Override
    public <T extends BalmConfigData> T getActive(Class<T> clazz) {
        return (T)this.activeConfigs.get(clazz);
    }

    public <T extends BalmConfigData> SyncConfigMessage<T> getConfigSyncMessage(Class<T> clazz) {
        Function<BalmConfigData, SyncConfigMessage<BalmConfigData>> factory = this.getConfigSyncMessageFactory(clazz);
        return factory != null ? factory.apply((BalmConfigData)this.getBackingConfig(clazz)) : null;
    }

    public <T extends BalmConfigData> Function<BalmConfigData, SyncConfigMessage<BalmConfigData>> getConfigSyncMessageFactory(Class<T> clazz) {
        return this.syncMessageFactories.get(clazz);
    }

    public <T extends BalmConfigData> void setActiveConfig(Class<T> clazz, T config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.activeConfigs.put(clazz, config);
    }

    @Override
    public <T extends BalmConfigData> void handleSync(class_1657 player, SyncConfigMessage<T> message) {
        BalmConfigData data = (BalmConfigData)message.getData();
        this.setActiveConfig(data.getClass(), data);
    }

    @Override
    public <T extends BalmConfigData> void registerConfig(Class<T> clazz, Function<T, SyncConfigMessage<T>> syncMessageFactory) {
        Balm.getConfig().initializeBackingConfig(clazz);
        this.defaultConfigs.put(clazz, (BalmConfigData)this.createConfigDataInstance(clazz));
        if (syncMessageFactory != null) {
            this.registerSyncMessageFactory(clazz, syncMessageFactory);
        }
    }

    private <T> void registerSyncMessageFactory(Class<T> clazz, Function<T, SyncConfigMessage<T>> syncMessageFactory) {
        this.syncMessageFactories.put(clazz, syncMessageFactory);
    }

    @Override
    public <T extends BalmConfigData> void updateConfig(Class<T> clazz, Consumer<T> consumer) {
        T backingConfig = this.getBackingConfig(clazz);
        consumer.accept(backingConfig);
        Balm.getConfig().saveBackingConfig(clazz);
        T activeConfig = this.getActive(clazz);
        if (activeConfig != backingConfig) {
            consumer.accept(this.getActive(clazz));
        }
    }

    @Override
    public <T extends BalmConfigData> void resetToBackingConfig(Class<T> clazz) {
        this.setActiveConfig(clazz, this.getBackingConfig(clazz));
    }

    @Override
    public void resetToBackingConfigs() {
        for (Class<?> clazz : this.activeConfigs.keySet()) {
            this.resetToBackingConfig(clazz);
        }
    }

    @NotNull
    protected <T> T createConfigDataInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Config class or sub-class missing a public no-arg constructor.", e);
        }
    }

    @Override
    public File getConfigFile(String configName) {
        return new File(this.getConfigDir(), configName + "-common.toml");
    }

    @Override
    public <T extends BalmConfigData> String getConfigName(Class<T> clazz) {
        Config configAnnotation = clazz.getAnnotation(Config.class);
        if (configAnnotation == null) {
            throw new IllegalArgumentException("Config class " + clazz.getName() + " is missing @Config annotation");
        }
        return configAnnotation.value();
    }

    @Override
    public <T extends BalmConfigData> Table<String, String, BalmConfigProperty<?>> getConfigProperties(Class<T> clazz) {
        T backingConfig = Balm.getConfig().getBackingConfig(clazz);
        BalmConfigData defaultConfig = this.defaultConfigs.get(clazz);
        HashBasedTable properties = HashBasedTable.create();
        for (Field rootField : ConfigReflection.getAllFields(clazz)) {
            String category = "";
            Class<?> fieldType = rootField.getType();
            if (AbstractBalmConfig.isPropertyType(fieldType)) {
                String property = rootField.getName();
                properties.put((Object)category, (Object)property, AbstractBalmConfig.createConfigProperty(backingConfig, null, rootField, defaultConfig));
                continue;
            }
            category = rootField.getName();
            for (Field propertyField : ConfigReflection.getAllFields(fieldType)) {
                String property = propertyField.getName();
                properties.put((Object)category, (Object)property, AbstractBalmConfig.createConfigProperty(backingConfig, rootField, propertyField, defaultConfig));
            }
        }
        return properties;
    }

    private static BalmConfigProperty<?> createConfigProperty(BalmConfigData configData, Field categoryField, Field propertyField, BalmConfigData defaultConfig) {
        return new BalmConfigPropertyImpl(configData, categoryField, propertyField, defaultConfig);
    }

    private static boolean isPropertyType(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Integer.class || type == Boolean.class || type == Float.class || type == Double.class || type == List.class || type == Set.class || type == class_151.class || Enum.class.isAssignableFrom(type);
    }
}

